# mmu2html.py
# Copyright (C) 2018 Ralf Hoffmann.
# ralf@boomerangsworld.de
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

class TagInfoEntry( object ):
    def __init__( self, menu_entry, title ):
        self.__menu_entry = menu_entry
        self.__title = title

    def title( self ):
        return self.__title

    def menuEntry( self ):
        return self.__menu_entry

class TagInfo( object ):
    
    def __init__( self, tag ):
        self.__tag = tag
        self.__files = []

    def addEntry( self, entry, title ):
        for e in self.__files:
            if e.menuEntry() == entry:
                break
        else:
            self.__files.append( TagInfoEntry( entry, title ) )

    def getEntries( self ):
        return self.__files

    def __repr__( self ):
        return repr( self.__files )
