#! /usr/bin/env python

from past import *

if __name__ == "__main__":

    d1 = Resource( "dev1", 50 )
    d2 = Resource( "dev2", 100 )

    m1 = Milestone( "version 1", "2013-9-9", 5 )

    m1.add( Task( "task 1", d1, 5, 0 ) )

    t3 = Task( "task 3", d2, 5, 0 )
    m1.add( t3 )

    m1.add( Task( "task 4", d2, 5, 0, None, 2 ) )
    m1.add( Task( "task 2", d2, 15, 25, t3, 1 ) )

    m2 = Milestone( "version 2", "2013-11-08", 10 )
    m2.add( Task( "big feature", d2, 40, 0 ) )
    m2.add( Task( "fixed task", d1, 5, 0, "2013-10-7" ) )
    m2.add( Task( "fixed task", d2, 3, 0, "2013-9-10" ) )

    s = PAST( "2013-07-29" )
    s.scheduleVacation( d2, "2013-07-30", 5 )

    s.scheduleMilestone( m1 )
    s.scheduleMilestone( m2 )

    s.printSchedule()
