/* runner.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2012 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef RUNNER_HH
#define RUNNER_HH

#include <string>
#include <map>
#include <aguix/message.h>
#include <memory>
#include <aguix/aguix.h>

#include "worker/pers_string_list.hh"

class AWindow;
class FieldListView;
class StringGadget;
class Button;
class AContainer;
class CycleButton;

class KnownPrograms
{
public:
    int read( const std::string &config_file );

    const std::list< std::pair< std::string, std::string > > &getList() const
    {
        return m_known_programs;
    }
private:
    std::list< std::pair< std::string, std::string > > m_known_programs;
};

class RunnerUI
{
public:
    RunnerUI( int argc, char **argv );
    ~RunnerUI();

    int mainLoop();

    void setConfigDir( const std::string &d );
    std::string getConfigDir();
private:
    int m_argc;
    char **m_argv;
    AGUIX *m_aguix;

    std::string m_filter;
    
    AWindow *m_win;
    FieldListView *m_lv;
    StringGadget *m_sg;
    Button *m_okb;
    Button *m_cancelb;
    AContainer *m_co1;
    CycleButton *m_mode_cyb;

    typedef enum {
        PATH_HIDE,
        PATH_SHOW,
        BOOKMARK_HIDE,
        BOOKMARK_SHOW,
        BOOKMARK_MATCHED,
        BOOKMARK_FLEXIBLE_MATCHED
    } entry_visibility_t;

    std::list< std::pair< entry_visibility_t, std::string > > m_entries;

    KnownPrograms m_programs;
    RefCount< PersistentStringList > m_history;
    std::string m_config_dir;
    std::list< std::string > m_commands_in_path;

    typedef enum {
        HISTORY_MODE,
        PATH_MODE
    } completion_mode_t;

    completion_mode_t m_completion_mode;

    void showData();
    void maximizeWin();

    int apply_filter( const std::string &filter );

    void highlight_best_hit( const std::string &filter );

    int handlePopupMsg( AGMessage *msg );

    void runProgramDialog();

    void runCommand( const std::string &cmd );

    void updateCompletionList( const std::string &prefix );

    void findCommands();

    void switchCompletionMode();
};

#endif
