/* wconfig_kvp_pool.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2025 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef WCONFIG_KVP_POOL_HH
#define WCONFIG_KVP_POOL_HH

#include "wdefines.h"
#include "aguix/akvp_pool.hh"
#include "wconfig_types.hh"
#include <map>
#include <set>

class Datei;

class WConfigKVPPool : public AKVPPool::AKVPPoolInterface {
public:
    WConfigKVPPool();

    void save( Datei *fh ) const;

    AKVPPool::AKVPPoolInterface::get_entry_result getEntry( const std::string &key ) const override;
    void setEntry( const std::string &key,
                   kvp_entry value ) override;
    void clear() override;
    std::set< std::string > getKeys() const override;
private:
    static const std::map< std::string, kvp_entry > s_all_entries;
    std::map< std::string, kvp_entry > m_entries;
};

#endif /* WCONFIG_KVP_POOL_HH */
