/* akvp_pool.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2025 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "akvp_pool.hh"
#include <memory>

using namespace AKVPPool;

static std::shared_ptr< AKVPPoolInterface > s_kvp_pool_instance;

class DummyKVPPool : public AKVPPool::AKVPPoolInterface {
public:
    DummyKVPPool() {}

    AKVPPoolInterface::get_entry_result getEntry( const std::string &key ) const override
    {
        return { .value = false,
                 .default_value = false,
                 .found = false,
                 .overwritten = false };
    }

    void setEntry( const std::string &key,
                   kvp_entry value ) override
    {
    }

    void clear() override
    {
    }

    std::set< std::string > getKeys() const override
    {
        return {};
    }
};

AKVPPoolInterface::~AKVPPoolInterface()
{
}

void AKVPPool::setGlobalKVPPool( std::shared_ptr< AKVPPoolInterface > pool )
{
    s_kvp_pool_instance = pool;
}

std::shared_ptr< AKVPPoolInterface > AKVPPool::getGlobalKVPPool()
{
    if ( ! s_kvp_pool_instance ) {
        s_kvp_pool_instance = std::make_shared< DummyKVPPool >();
    }

    return s_kvp_pool_instance;
}
